//	CDiskCpm.h

#ifndef _H_CDiskCpm
#define _H_CDiskCpm

#include "CDisk.h"
#include "CpmStructs.h"

void		Cpm_EraseDisk(DiskImageRec *imageRecP);
void		Cpm_SanitizeName(char *nameZ);

typedef	OSErr	(*Cpm_ForEachBitmapBlockCB)(
	CDiskCpm		*thiz, 
	Cpm_BlockNum	block, 
	Boolean			*free, 
	Boolean			*done, 
	void			*data);

class CDesktop;
class CDiskCpm : public CDisk {

	public:	
	
	OSErr		IDiskCpm(
		CDesktop		*desktop, 
		DiskImageRec	*imageRec);
	
	virtual	void		Dispose(void);

	virtual	OSErr		VerifyFreeSpace(ulong sizeL);
	virtual	OSErr		BuildFileTypeMenu(void);
	virtual	short		MenuItemToFileType(short menuItem, ushort *auxType);
	virtual	char		*GetName(char *buf);
	virtual	Cpm_Block	*GetBlock(Cpm_BlockNum block);
	virtual	OSErr		SetBlock(void);
	virtual ADFS_IconType		GetIconType(void);
	virtual char		*GetDescription(char *buf);
	virtual	ulong		GetVolumeSize(void);
	
	virtual	Boolean		CanRename(void);

	OSErr				IsBlockFree(Cpm_BlockNum curBlock, Boolean *isFreeB);

	OSErr				Cpm_ForEachBitmapBlock(
		Cpm_ForEachBitmapBlockCB	ForEachBitmapBlockUserCB, 
		void						*data);

	virtual	ulong		GetVolumeBytesUsed(void);
	virtual	OSErr		ZeroUnused(void);
	virtual	OSErr		NewDisk_Completion(ADFS_NewDiskCompletionRec *recP);
	
	OSErr				GetFreeBlock(Cpm_BlockNum *freeBlock);
	ulong				GetVolumeMaxFileSize(ushort pro_fileTypeS);
	ulong				CalcBytesUsedByFile(ulong fileSize);

	void			SetTwirled(Boolean twirledB);	
	Boolean			GetTwirled(void);

	CFileCpm		*GetFileFromEntry(Cpm_DirEntry *entryP);

	void			OffsetEachFile(
		CFileCpm		*firstFileP, 
		CFileCpm		*lastFileP, 
		Cpm_EntryIndex	offsetL);

	Cpm_DirEntry	*ScanForNextEmpty(
		Cpm_DirEntry	*entryP, 
		Cpm_EntryIndex	*offsetP,
		Cpm_DirEntry	**lastRealEntryPP);

	OSErr			Cpm_GetNextFreeExtentAlloc(
		Cpm_DirEntry	**entryPP, 
		Cpm_BlockNum	**blockNumPP);

	/***********  disk map stuff *************************/
	OSErr		GetUnAllocBlocks(
		Boolean			getAsBlocksB,
		Cpm_BlockNum	*maxEmptyS, 
		Cpm_BlockNum	*blockListA);

	OSErr		GetEntryAlloc(
		Boolean			getAsBlocksB, 
		Gen_EntryAlloc	**sectorListH);

	ushort					GetSectorsPerBlock(void);
	ushort					GetBlocksPerTrack(void);
	Gen_AllocSizeType		GetAllocSize(void);

	/**************************************************************/
	//	instance vars
	Cpm_Block		*i_blockBuf;
	Cpm_BlockNum	i_recentBlockNum;		//	from most recent GetSector

	private:
	typedef CDisk _inherited;
};

#endif
